/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.path.matcher.FilePathMatcher;
import org.anchoranalysis.io.input.bean.path.matcher.PredicateFromPathMatcher;

public class MatchRegularExpression
extends FilePathMatcher {
    @BeanField
    private boolean applyToPath = false;
    @BeanField
    private String expression;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.expression.contains("\\\\")) {
            throw new BeanMisconfiguredException("A double backslash is present in expression, but is not permitted: " + this.expression);
        }
    }

    @Override
    protected CheckedPredicate<Path, IOException> createMatcherFile(Path directory, Optional<InputContextParameters> inputContext) {
        return PredicateFromPathMatcher.create(directory, "regex", this.expressionMatchingSlashes(), !this.applyToPath);
    }

    private String expressionMatchingSlashes() {
        if (File.separatorChar == '\\') {
            return this.expression.replace("/", "\\\\");
        }
        return this.expression;
    }

    @Override
    protected boolean canMatchSubdirectories() {
        return true;
    }

    @Generated
    public boolean isApplyToPath() {
        return this.applyToPath;
    }

    @Generated
    public void setApplyToPath(boolean applyToPath) {
        this.applyToPath = applyToPath;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }
}

