/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.path.matcher.FindMatchingFiles;
import org.anchoranalysis.io.input.bean.path.matcher.HiddenPathChecker;
import org.anchoranalysis.io.input.path.matcher.DualPathPredicates;
import org.anchoranalysis.io.input.path.matcher.FindFilesException;

public abstract class FilePathMatcher
extends AnchorBean<FilePathMatcher> {
    public List<File> matchingFiles(Path directory, boolean recursive) throws InputReadFailedException {
        return this.matchingFiles(directory, recursive, false, true, Optional.empty(), Optional.empty());
    }

    public List<File> matchingFiles(Path directory, boolean recursive, boolean ignoreHidden, boolean acceptDirectoryErrors, Optional<Integer> maxDirectoryDepth, Optional<InputManagerParameters> parameters) throws InputReadFailedException {
        FilePathMatcher.checkDirectoryPreconditions(directory);
        DualPathPredicates predicates = this.createPredicates(directory, ignoreHidden, parameters.map(InputManagerParameters::getInputContext));
        try {
            return FindMatchingFiles.search(directory, predicates, recursive && this.canMatchSubdirectories(), maxDirectoryDepth);
        }
        catch (FindFilesException e) {
            throw new InputReadFailedException("Cannot find matching files", (Throwable)((Object)e));
        }
    }

    protected abstract CheckedPredicate<Path, IOException> createMatcherFile(Path var1, Optional<InputContextParameters> var2) throws InputReadFailedException;

    protected abstract boolean canMatchSubdirectories();

    private DualPathPredicates createPredicates(Path directory, boolean ignoreHidden, Optional<InputContextParameters> parameters) throws InputReadFailedException {
        CheckedPredicate<Path, IOException> fileMatcher = this.maybeAddIgnoreHidden(ignoreHidden, this.createMatcherFile(directory, parameters));
        CheckedPredicate<Path, IOException> directoryMatcher = this.maybeAddIgnoreHidden(ignoreHidden, (CheckedPredicate<Path, IOException>)((CheckedPredicate)path -> true));
        return new DualPathPredicates(fileMatcher, directoryMatcher);
    }

    private CheckedPredicate<Path, IOException> maybeAddIgnoreHidden(boolean ignoreHidden, CheckedPredicate<Path, IOException> predicate) {
        if (ignoreHidden) {
            return path -> predicate.test(path) && HiddenPathChecker.includePath(path);
        }
        return predicate;
    }

    private static void checkDirectoryPreconditions(Path directory) throws InputReadFailedException {
        if (directory.toString().isEmpty()) {
            throw new InputReadFailedException("The directory is unspecified (an empty string) which is not allowed. Consider using '.' for the current working directory");
        }
        if (!directory.toFile().exists() || !directory.toFile().isDirectory()) {
            throw new InputReadFailedException(String.format("Directory '%s' does not exist", directory.toAbsolutePath().normalize()));
        }
    }
}

