/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.namer;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.NamedFile;

public abstract class FileNamer
extends AnchorBean<FileNamer> {
    public NamedFile deriveName(File file, FileNamerContext context) {
        return this.deriveName(Arrays.asList(file), context).get(0);
    }

    public abstract List<NamedFile> deriveName(List<File> var1, FileNamerContext var2);

    public List<NamedFile> deriveNameUnique(List<File> files, FileNamerContext context) throws InputReadFailedException {
        List<NamedFile> list = this.deriveName(files, context);
        FileNamer.checkUniqueness(list);
        FileNamer.checkNoPredicate(list, FileNamer::containsBackslash, "contain backslashes");
        FileNamer.checkNoPredicate(list, FileNamer::emptyString, "contain an empty string");
        return list;
    }

    private static void checkUniqueness(List<NamedFile> list) throws InputReadFailedException {
        Map<String, Long> countDescriptiveNames = list.stream().collect(Collectors.groupingBy(NamedFile::getIdentifier, Collectors.counting()));
        for (Map.Entry<String, Long> entry : countDescriptiveNames.entrySet()) {
            if (entry.getValue() <= 1L) continue;
            throw new InputReadFailedException(String.format("The extracted names are not unique for %s.%nThe following have the same name:%n%s", entry.getKey(), FileNamer.keysWithName(entry.getKey(), list)));
        }
    }

    private static void checkNoPredicate(List<NamedFile> list, Predicate<String> predicate, String dscr) throws InputReadFailedException {
        long numWithBackslashes = list.stream().filter(file -> predicate.test(file.getIdentifier())).count();
        if (numWithBackslashes > 0L) {
            throw new InputReadFailedException(String.format("The following names may not %s:%n%s", dscr, FileNamer.keysWithNamePredicate(predicate, list)));
        }
    }

    private static String keysWithName(String name, List<NamedFile> list) {
        return FileNamer.keysWithNamePredicate(file -> file.equals(name), list);
    }

    private static String keysWithNamePredicate(Predicate<String> predicate, List<NamedFile> list) {
        List<String> matches = list.stream().filter(file -> predicate.test(file.getIdentifier())).map(file -> file.getPath().toString()).toList();
        return String.join((CharSequence)System.lineSeparator(), matches);
    }

    private static boolean containsBackslash(String value) {
        return value.contains("\\");
    }

    private static boolean emptyString(String value) {
        return value == null || value.isEmpty();
    }
}

