/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.grouper;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.bean.grouper.Grouper;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.grouper.InputGrouper;
import org.anchoranalysis.io.input.path.DerivePathException;

public abstract class FromDerivePath
extends Grouper {
    @Override
    public Optional<InputGrouper> createInputGrouper(Optional<IndexRangeNegative> groupIndexRange) {
        return Optional.of(this::deriveGroupKey);
    }

    protected abstract DerivePath selectDerivePath();

    private String deriveGroupKey(Path identifier) throws DerivePathException {
        Path path = this.selectDerivePath().deriveFrom(identifier, false);
        assert (!path.isAbsolute());
        return FilePathToUnixStyleConverter.toStringUnixStyle((Path)path);
    }
}

