/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.files;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.files.FilesProviderWithDirectory;

public abstract class FilesProviderWithDirectoryString
extends FilesProviderWithDirectory {
    @BeanField
    @AllowEmpty
    private String directory = "";
    @BeanField
    private boolean localized = false;

    @Override
    public Path getDirectoryAsPath(InputContextParameters inputContext) {
        if (!this.directory.isEmpty()) {
            Path directoryAsPath = Paths.get(this.directory, new String[0]);
            Optional<Path> localRoot = this.calculateLocalRoot();
            if (this.localized && !directoryAsPath.isAbsolute() && localRoot.isPresent()) {
                return localRoot.get().resolve(directoryAsPath);
            }
            return directoryAsPath;
        }
        return this.inferDirectory(inputContext);
    }

    private Path inferDirectory(InputContextParameters inputContext) {
        Optional<Path> localRoot = this.calculateLocalRoot();
        if (this.localized && localRoot.isPresent()) {
            return localRoot.get();
        }
        return inputContext.getInputDirectory().orElseGet(() -> Paths.get(".", new String[0]));
    }

    private Optional<Path> calculateLocalRoot() {
        return this.getLocalPath().flatMap(path -> Optional.ofNullable(path.getParent()));
    }

    @Generated
    public String getDirectory() {
        return this.directory;
    }

    @Generated
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Generated
    public boolean isLocalized() {
        return this.localized;
    }

    @Generated
    public void setLocalized(boolean localized) {
        this.localized = localized;
    }
}

