/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.files;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProvider;
import org.anchoranalysis.io.input.file.FilesProviderException;

public abstract class FilesProviderWithDirectory
extends FilesProvider {
    @Override
    public final List<File> create(InputManagerParameters parameters) throws FilesProviderException {
        return this.matchingFilesForDirectory(this.getDirectoryAsPath(parameters.getInputContext()), parameters);
    }

    @Override
    public Optional<Path> rootDirectory(InputContextParameters inputContext) {
        return Optional.of(this.getDirectoryAsPath(inputContext));
    }

    public abstract Path getDirectoryAsPath(InputContextParameters var1);

    public abstract List<File> matchingFilesForDirectory(Path var1, InputManagerParameters var2) throws FilesProviderException;

    public Path getDirectoryAsPathEnsureAbsolute(InputContextParameters inputContext) {
        return this.makeAbsolutePathIfNecessary(this.getDirectoryAsPath(inputContext));
    }

    private Path makeAbsolutePathIfNecessary(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        Optional localPath = this.getLocalPath();
        if (localPath.isPresent()) {
            Path parent = ((Path)localPath.get()).getParent();
            return parent.resolve(path);
        }
        return path.toAbsolutePath();
    }
}

