/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.file.NamedFile;

public interface InputFromManager {
    public String identifier();

    default public Path identifierAsPath() {
        return Paths.get(this.identifier(), new String[0]);
    }

    public Optional<Path> pathForBinding();

    default public Path pathForBindingRequired() throws InputReadFailedException {
        return this.pathForBinding().orElseThrow(() -> new InputReadFailedException("A binding path is required to be associated with each input for this algorithm, but is not"));
    }

    default public NamedFile asFile() throws InputReadFailedException {
        return new NamedFile(this.identifier(), this.pathForBindingRequired().toFile());
    }

    default public List<Path> allAssociatedPaths() {
        Optional<Path> bindingPath = this.pathForBinding();
        if (bindingPath.isPresent()) {
            return Arrays.asList(bindingPath.get());
        }
        return new ArrayList<Path>();
    }

    default public void close(ErrorReporter errorReporter) {
    }
}

