/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.file.NamedFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

class FindNonInputFiles {
    public static <T extends InputFromManager> Collection<NamedFile> from(Path inputDirectory, List<T> inputs) throws OperationFailedException {
        Set<Path> set = FindNonInputFiles.convertToSet(FindNonInputFiles.findAllFilesInDirectory(inputDirectory));
        FindNonInputFiles.removeAnyInputPaths(set, inputs);
        return FunctionalList.mapToList(set, OperationFailedException.class, file -> FindNonInputFiles.addIdentifier(file, inputDirectory));
    }

    private static Collection<File> findAllFilesInDirectory(Path directory) {
        return FileUtils.listFiles((File)directory.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    private static Set<Path> convertToSet(Collection<File> files) {
        return new TreeSet<Path>(FunctionalList.mapToList(files, FindNonInputFiles::makeAbsolute));
    }

    private static <T extends InputFromManager> void removeAnyInputPaths(Set<Path> setToRemoveFrom, List<T> inputs) {
        for (InputFromManager input : inputs) {
            input.allAssociatedPaths().forEach(path -> setToRemoveFrom.remove(FindNonInputFiles.makeAbsolute(path)));
        }
    }

    private static NamedFile addIdentifier(Path path, Path directory) throws OperationFailedException {
        if (path.startsWith(directory = FindNonInputFiles.makeAbsolute(directory))) {
            String identifier = FilePathToUnixStyleConverter.toStringUnixStyle((Path)directory.relativize(path));
            return new NamedFile(identifier, path.toFile());
        }
        throw new OperationFailedException(String.format("An input file exists outside the input-directory: %s with input-directory %s", path, directory));
    }

    private static Path makeAbsolute(File file) {
        return FindNonInputFiles.makeAbsolute(file.toPath());
    }

    private static Path makeAbsolute(Path path) {
        return path.normalize().toAbsolutePath();
    }

    @Generated
    private FindNonInputFiles() {
    }
}

