/*-
 * #%L
 * anchor-io
 * %%
 * Copyright (C) 2010 - 2020 Owen Feehan, ETH Zurich, University of Zurich, Hoffmann-La Roche
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

package org.anchoranalysis.io.input.bean;

import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;

/**
 * Base class for describing the inputs.
 *
 * <p>By inputs, this refers to files that form the necessary input to an experiment.
 *
 * <p>This is an import class in specifying an <a
 * href="https://www.anchoranalysis.org/user_guide.html#essentials-of-anchor">experiment</a> in the
 * Anchor platform, of which many different implementations specify different types and combinations
 * of inputs.
 *
 * @author Owen Feehan
 * @param <T> input-type
 */
public abstract class InputManager<T extends InputFromManager> extends AnchorBean<InputManager<T>> {

    /**
     * Creates a list of inputs given particular parameters.
     *
     * @param parameters the parameters.
     * @return the list of inputs, together with any associated parent directory.
     * @throws InputReadFailedException if inputs cannot be successfully read from the file-system.
     */
    public abstract InputsWithDirectory<T> inputs(InputManagerParameters parameters)
            throws InputReadFailedException;
}
