/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.inference.concurrency;

import lombok.Generated;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.value.LanguageUtilities;

class GPUMessageLogger {
    private static final String CUDA_VERSION = "11.2";

    public static void maybeLog(int numberPlanned, int numberAllocated, MessageLogger logger) {
        if (numberPlanned == 0) {
            return;
        }
        if (numberAllocated == numberPlanned) {
            logger.logFormatted("%s.", new Object[]{GPUMessageLogger.prefixGPUAllocation(numberPlanned, true)});
        } else {
            String prefix = GPUMessageLogger.prefixGPUAllocation(numberPlanned, false);
            String suffix = "Using available CPUs instead.";
            if (numberAllocated > 0) {
                logger.logFormatted("%s, but only %d could be allocated. %s", new Object[]{prefix, numberPlanned, numberAllocated, suffix});
            } else {
                logger.logFormatted("%s, but %s could not be allocated. %s", new Object[]{prefix, LanguageUtilities.multiplexPlural((long)numberPlanned, (String)"it", (String)"they"), suffix});
            }
        }
    }

    private static String prefixGPUAllocation(int numberPlanned, boolean includeSuccessful) {
        return String.format("%d GPU %s %s %srequested using the ONNX Runtime (CUDA Version %s)", numberPlanned, LanguageUtilities.pluralizeMaybe((long)numberPlanned, (String)"processor"), LanguageUtilities.multiplexPlural((long)numberPlanned, (String)"was", (String)"were"), includeSuccessful ? "successfully " : "", CUDA_VERSION);
    }

    @Generated
    private GPUMessageLogger() {
    }
}

