/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.inference.concurrency;

public class ConcurrencyPlan {
    public static final int DEFAULT_NUMBER_GPUS = 1;
    private final int numberCPUs;
    private final int numberGPUs;

    public static ConcurrencyPlan noCPUProcessor() {
        return new ConcurrencyPlan(0, 1);
    }

    public static ConcurrencyPlan singleCPUProcessor() {
        return ConcurrencyPlan.singleCPUProcessor(1);
    }

    public static ConcurrencyPlan singleCPUProcessor(int maxNumberGPUs) {
        return new ConcurrencyPlan(1, maxNumberGPUs);
    }

    public static ConcurrencyPlan multipleProcessors(int maxNumberCPUs, int maxNumberGPUs) {
        return new ConcurrencyPlan(maxNumberCPUs, maxNumberGPUs);
    }

    public ConcurrencyPlan disableGPUs() {
        return new ConcurrencyPlan(this.numberCPUs, 0);
    }

    public int numberCPUs() {
        return this.numberCPUs;
    }

    public int numberGPUs() {
        return this.numberGPUs;
    }

    private ConcurrencyPlan(int numberCPUs, int numberGPUs) {
        this.numberCPUs = Math.max(numberCPUs, numberGPUs);
        this.numberGPUs = Math.min(numberGPUs, numberCPUs);
    }
}

