/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.resizer;

import ij.process.ImageProcessor;
import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.io.imagej.convert.ConvertToImageProcessor;
import org.anchoranalysis.io.imagej.convert.ConvertToVoxelBuffer;
import org.anchoranalysis.spatial.box.Extent;

public class VoxelsResizerImageJ
extends VoxelsResizer {
    public boolean canValueRangeChange() {
        return true;
    }

    public VoxelBuffer<UnsignedByteBuffer> resizeByte(VoxelBuffer<UnsignedByteBuffer> voxelsSource, VoxelBuffer<UnsignedByteBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        ImageProcessor source = ConvertToImageProcessor.fromByte(voxelsSource, extentSource);
        ImageProcessor destination = VoxelsResizerImageJ.resize(source, extentDestination);
        return ConvertToVoxelBuffer.asByte(destination);
    }

    public VoxelBuffer<UnsignedShortBuffer> resizeShort(VoxelBuffer<UnsignedShortBuffer> voxelsSource, VoxelBuffer<UnsignedShortBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        ImageProcessor source = ConvertToImageProcessor.fromShort(voxelsSource, extentSource);
        ImageProcessor destination = VoxelsResizerImageJ.resize(source, extentDestination);
        return ConvertToVoxelBuffer.asShort(destination);
    }

    public VoxelBuffer<FloatBuffer> resizeFloat(VoxelBuffer<FloatBuffer> voxelsSource, VoxelBuffer<FloatBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        ImageProcessor source = ConvertToImageProcessor.fromFloat(voxelsSource, extentSource);
        ImageProcessor destination = VoxelsResizerImageJ.resize(source, extentDestination);
        return ConvertToVoxelBuffer.asFloat(destination);
    }

    private static ImageProcessor resize(ImageProcessor source, Extent extentDestination) {
        source.setInterpolate(true);
        return source.resize(extentDestination.x(), extentDestination.y(), true);
    }
}

