/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.convert;

import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.nio.FloatBuffer;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.spatial.box.Extent;

public class ConvertToImageProcessor {
    private static final VoxelDataType DATA_TYPE_BYTE = UnsignedByteVoxelType.INSTANCE;
    private static final VoxelDataType DATA_TYPE_SHORT = UnsignedShortVoxelType.INSTANCE;

    public static ImageProcessor from(VoxelsUntyped voxels, int z) throws ImageJConversionException {
        if (voxels.any().extent().areaXY() != voxels.slice(z).capacity()) {
            throw new AnchorFriendlyRuntimeException(String.format("Extent volume (%d) and buffer-capacity (%d) are not equal", voxels.any().extent().areaXY(), voxels.slice(z).capacity()));
        }
        if (voxels.getVoxelDataType().equals((Object)DATA_TYPE_BYTE)) {
            return ConvertToImageProcessor.fromByte((SliceBufferIndex<UnsignedByteBuffer>)voxels.asByte().slices(), z);
        }
        if (voxels.getVoxelDataType().equals((Object)DATA_TYPE_SHORT)) {
            return ConvertToImageProcessor.fromShort((SliceBufferIndex<UnsignedShortBuffer>)voxels.asShort().slices(), z);
        }
        throw new ImageJConversionException("Only byte or short data types are supported");
    }

    public static ImageProcessor fromByte(SliceBufferIndex<UnsignedByteBuffer> pixelsForSlice, int z) {
        return ConvertToImageProcessor.fromByte((VoxelBuffer<UnsignedByteBuffer>)pixelsForSlice.slice(z), pixelsForSlice.extent());
    }

    public static ImageProcessor fromShort(SliceBufferIndex<UnsignedShortBuffer> pixelsForSlice, int z) {
        return ConvertToImageProcessor.fromShort((VoxelBuffer<UnsignedShortBuffer>)pixelsForSlice.slice(z), pixelsForSlice.extent());
    }

    public static ImageProcessor fromByte(VoxelBuffer<UnsignedByteBuffer> slice, Extent extent) {
        return new ByteProcessor(extent.x(), extent.y(), ((UnsignedByteBuffer)slice.buffer()).array(), null);
    }

    public static ImageProcessor fromShort(VoxelBuffer<UnsignedShortBuffer> slice, Extent extent) {
        return new ShortProcessor(extent.x(), extent.y(), ((UnsignedShortBuffer)slice.buffer()).array(), null);
    }

    public static ImageProcessor fromFloat(VoxelBuffer<FloatBuffer> slice, Extent extent) {
        return new FloatProcessor(extent.x(), extent.y(), ((FloatBuffer)slice.buffer()).array(), null);
    }

    @Generated
    private ConvertToImageProcessor() {
    }
}

