/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.bean.stack.writer;

import ij.ImagePlus;
import ij.io.FileSaver;
import java.nio.file.Path;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.bean.stack.writer.WriterErrorMessageHelper;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.io.imagej.convert.ConvertToImagePlus;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ImageJRasterWriter
extends StackWriter {
    private static Log log = LogFactory.getLog(ImageJRasterWriter.class);

    public void writeStack(Stack stack, Path filePath, StackWriteOptions options) throws ImageIOException {
        if (stack.getNumberChannels() != 1 && stack.getNumberChannels() != 3) {
            throw new ImageIOException("Stack must have 1 or 3 channels");
        }
        if (!stack.allChannelsHaveIdenticalType()) {
            throw new ImageIOException("Stack must have identically-typed channels");
        }
        if (stack.getNumberChannels() == 3 && !stack.isRGB()) {
            throw new ImageIOException("A three-channeled stack must have the RGB flag set to true.");
        }
        this.writeStackTime(stack, filePath, options.getAttributes().writeAsRGB(stack));
    }

    protected abstract boolean writeRaster(FileSaver var1, String var2, boolean var3) throws ImageIOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStackTime(Stack stack, Path path, boolean makeRGB) throws ImageIOException {
        ImagePlus image;
        log.debug((Object)String.format("Writing image %s", path));
        Dimensions dimensions = stack.getChannel(0).dimensions();
        try {
            image = ConvertToImagePlus.from(stack, makeRGB);
        }
        catch (ImageJConversionException e) {
            throw WriterErrorMessageHelper.generalWriteException(ImageJRasterWriter.class, (Path)path, (Exception)((Object)e));
        }
        try {
            this.writeImagePlus(image, path, stack.hasMoreThanOneSlice());
        }
        finally {
            image.close();
        }
        if (image.getNSlices() != dimensions.z()) {
            throw new ImageIOException(String.format("The number of slices in the ImagePlus (%d) is not the same as the image dimensions (%d)", image.getNSlices(), dimensions.z()));
        }
        log.debug((Object)String.format("Finished writing image %s", path));
    }

    private void writeImagePlus(ImagePlus image, Path filePath, boolean asStack) throws ImageIOException {
        FileSaver fileSaver = new FileSaver(image);
        if (!this.writeRaster(fileSaver, filePath.toString(), asStack)) {
            throw new ImageIOException(String.format("An error occured in IJ writing file '%s'", filePath));
        }
    }
}

