/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.convert;

import ij.process.ColorProcessor;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.spatial.box.Extent;

class RGBVoxels {
    private Voxels<UnsignedByteBuffer> red;
    private Voxels<UnsignedByteBuffer> green;
    private Voxels<UnsignedByteBuffer> blue;

    public ColorProcessor createColorProcessor(Extent extent, int z) {
        ColorProcessor processor = new ColorProcessor(extent.x(), extent.y());
        processor.setRGB(RGBVoxels.extractSlice(this.red, z), RGBVoxels.extractSlice(this.green, z), RGBVoxels.extractSlice(this.blue, z));
        return processor;
    }

    private static byte[] extractSlice(Voxels<UnsignedByteBuffer> voxels, int z) {
        return ((UnsignedByteBuffer)voxels.sliceBuffer(z)).array();
    }

    public RGBVoxels(Voxels<UnsignedByteBuffer> red, Voxels<UnsignedByteBuffer> green, Voxels<UnsignedByteBuffer> blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }
}

