/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.convert;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.io.imagej.convert.ConvertToVoxelBuffer;
import org.anchoranalysis.spatial.box.Extent;

public class ConvertFromImagePlus {
    public static Channel toChannel(ImagePlus imagePlus, Optional<Resolution> resolution) {
        return new Channel(ConvertFromImagePlus.toVoxels(imagePlus).any(), resolution);
    }

    public static VoxelsUntyped toVoxels(ImagePlus image) {
        if (image.getType() == 0) {
            return ConvertFromImagePlus.deriveCopiedVoxels(image, VoxelsFactory.getUnsignedByte(), ConvertToVoxelBuffer::asByte);
        }
        if (image.getType() == 1) {
            return ConvertFromImagePlus.deriveCopiedVoxels(image, VoxelsFactory.getUnsignedShort(), ConvertToVoxelBuffer::asShort);
        }
        throw new IncorrectVoxelTypeException("Only unsigned-8 and unsigned 16bit supported");
    }

    private static <T> VoxelsUntyped deriveCopiedVoxels(ImagePlus image, VoxelsFactoryTypeBound<T> factory, Function<ImageProcessor, VoxelBuffer<T>> convertProcessor) {
        Voxels voxels = factory.createInitialized(ConvertFromImagePlus.deriveExtent(image));
        ConvertFromImagePlus.copyStackIntoVoxels(image.getImageStack(), voxels, convertProcessor);
        return new VoxelsUntyped(voxels);
    }

    private static <T> void copyStackIntoVoxels(ImageStack source, Voxels<T> destination, Function<ImageProcessor, VoxelBuffer<T>> convertProcessor) {
        destination.extent().iterateOverZ(z -> {
            ImageProcessor processor = source.getProcessor(z + 1);
            destination.replaceSlice(z, (VoxelBuffer)convertProcessor.apply(processor));
        });
    }

    private static Extent deriveExtent(ImagePlus image) {
        return new Extent(image.getWidth(), image.getHeight(), image.getStackSize());
    }

    private ConvertFromImagePlus() {
    }
}

