/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.statistics;

import org.anchoranalysis.bean.shared.relation.threshold.RelationToThreshold;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.math.statistics.VarianceCalculatorLong;

public interface VoxelStatistics {
    public long size();

    public long sum();

    public long sumOfSquares();

    public VoxelStatistics threshold(RelationToThreshold var1);

    public double quantile(double var1) throws OperationFailedException;

    public Histogram histogram() throws OperationFailedException;

    public long countThreshold(RelationToThreshold var1);

    default public double mean() {
        return (double)this.sum() / (double)this.size();
    }

    default public double variance() {
        return new VarianceCalculatorLong(this.sum(), this.sumOfSquares(), this.size()).variance();
    }

    default public double stdDev() {
        return Math.sqrt(this.variance());
    }
}

