/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.resizer;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.Extent;

public class VoxelsResizerNone
extends VoxelsResizer {
    @Override
    public VoxelBuffer<UnsignedByteBuffer> resizeByte(VoxelBuffer<UnsignedByteBuffer> voxelsSource, VoxelBuffer<UnsignedByteBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        VoxelsResizerNone.copyByte(voxelsSource.buffer(), voxelsDestination.buffer(), extentSource, extentDestination);
        return voxelsDestination;
    }

    @Override
    public VoxelBuffer<UnsignedShortBuffer> resizeShort(VoxelBuffer<UnsignedShortBuffer> voxelsSource, VoxelBuffer<UnsignedShortBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        VoxelsResizerNone.copyShort(voxelsSource.buffer(), voxelsDestination.buffer(), extentSource, extentDestination);
        return voxelsDestination;
    }

    @Override
    public VoxelBuffer<FloatBuffer> resizeFloat(VoxelBuffer<FloatBuffer> voxelsSource, VoxelBuffer<FloatBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        VoxelsResizerNone.copyFloat(voxelsSource.buffer(), voxelsDestination.buffer(), extentSource, extentDestination);
        return voxelsDestination;
    }

    @Override
    public boolean canValueRangeChange() {
        return false;
    }

    private static void copyByte(UnsignedByteBuffer bufferIn, UnsignedByteBuffer bufferOut, Extent extentIn, Extent extentOut) {
        double xScale = VoxelsResizerNone.intDiv(extentIn.x(), extentOut.x());
        double yScale = VoxelsResizerNone.intDiv(extentIn.y(), extentOut.y());
        for (int y = 0; y < extentOut.y(); ++y) {
            for (int x = 0; x < extentOut.x(); ++x) {
                int xOrig = VoxelsResizerNone.intMin(xScale * (double)x, extentIn.x() - 1);
                int yOrig = VoxelsResizerNone.intMin(yScale * (double)y, extentIn.y() - 1);
                bufferOut.putRaw(bufferIn.getRaw(extentIn.offset(xOrig, yOrig)));
            }
        }
    }

    private static void copyShort(UnsignedShortBuffer bufferIn, UnsignedShortBuffer bufferOut, Extent extentIn, Extent extentOut) {
        double xScale = VoxelsResizerNone.intDiv(extentIn.x(), extentOut.x());
        double yScale = VoxelsResizerNone.intDiv(extentIn.y(), extentOut.y());
        for (int y = 0; y < extentOut.y(); ++y) {
            for (int x = 0; x < extentOut.x(); ++x) {
                int xOrig = VoxelsResizerNone.intMin(xScale * (double)x, extentIn.x() - 1);
                int yOrig = VoxelsResizerNone.intMin(yScale * (double)y, extentIn.y() - 1);
                bufferOut.putRaw(bufferIn.getRaw(extentIn.offset(xOrig, yOrig)));
            }
        }
    }

    private static void copyFloat(FloatBuffer bufferIn, FloatBuffer bufferOut, Extent extentIn, Extent extentOut) {
        double xScale = VoxelsResizerNone.intDiv(extentIn.x(), extentOut.x());
        double yScale = VoxelsResizerNone.intDiv(extentIn.y(), extentOut.y());
        for (int y = 0; y < extentOut.y(); ++y) {
            for (int x = 0; x < extentOut.x(); ++x) {
                int xIn = VoxelsResizerNone.intMin(xScale * (double)x, extentIn.x() - 1);
                int yIn = VoxelsResizerNone.intMin(yScale * (double)y, extentIn.y() - 1);
                bufferOut.put(bufferIn.get(extentIn.offset(xIn, yIn)));
            }
        }
    }

    private static double intDiv(int numerator, int denominator) {
        return (double)numerator / (double)denominator;
    }

    private static int intMin(double val1, int val2) {
        return (int)Math.min(Math.round(val1), (long)val2);
    }
}

