/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.resizer;

import java.nio.FloatBuffer;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.Extent;

public class VoxelsResizerExecutionTime
extends VoxelsResizer {
    private final VoxelsResizer resizer;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final String identifierByte;
    private final String identifierShort;
    private final String identifierFloat;

    public VoxelsResizerExecutionTime(VoxelsResizer resizer, ExecutionTimeRecorder executionTimeRecorder, String operationIdentifierPrefix) {
        this.resizer = resizer;
        this.executionTimeRecorder = executionTimeRecorder;
        this.identifierByte = VoxelsResizerExecutionTime.buildIdentifier("byte", operationIdentifierPrefix);
        this.identifierShort = VoxelsResizerExecutionTime.buildIdentifier("short", operationIdentifierPrefix);
        this.identifierFloat = VoxelsResizerExecutionTime.buildIdentifier("float", operationIdentifierPrefix);
    }

    @Override
    public boolean canValueRangeChange() {
        return this.resizer.canValueRangeChange();
    }

    @Override
    protected VoxelBuffer<UnsignedByteBuffer> resizeByte(VoxelBuffer<UnsignedByteBuffer> voxelsSource, VoxelBuffer<UnsignedByteBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        return (VoxelBuffer)this.executionTimeRecorder.recordExecutionTime(this.identifierByte, () -> this.resizer.resizeByte(voxelsSource, voxelsDestination, extentSource, extentDestination));
    }

    @Override
    protected VoxelBuffer<UnsignedShortBuffer> resizeShort(VoxelBuffer<UnsignedShortBuffer> voxelsSource, VoxelBuffer<UnsignedShortBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        return (VoxelBuffer)this.executionTimeRecorder.recordExecutionTime(this.identifierShort, () -> this.resizer.resizeShort(voxelsSource, voxelsDestination, extentSource, extentDestination));
    }

    @Override
    protected VoxelBuffer<FloatBuffer> resizeFloat(VoxelBuffer<FloatBuffer> voxelsSource, VoxelBuffer<FloatBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        return (VoxelBuffer)this.executionTimeRecorder.recordExecutionTime(this.identifierFloat, () -> this.resizer.resizeFloat(voxelsSource, voxelsDestination, extentSource, extentDestination));
    }

    private static String buildIdentifier(String dataType, String operationIdentifierPrefix) {
        return String.format("%s - %s", operationIdentifierPrefix, dataType);
    }
}

