/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.resizer;

import java.util.function.Function;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.Extent;

class TransferViaSpecificType<T> {
    private final TransferSlice<T> transferSlice;
    private final Voxels<T> source;
    private final Voxels<T> destination;
    private VoxelBuffer<T> slice;

    public TransferViaSpecificType(VoxelsUntyped source, VoxelsUntyped destination, Function<VoxelsUntyped, Voxels<T>> extractVoxels, TransferSlice<T> transferSlice) {
        this.source = extractVoxels.apply(source);
        this.destination = extractVoxels.apply(destination);
        this.transferSlice = transferSlice;
    }

    public void assignSlice(int z) {
        this.slice = this.source.slice(z);
    }

    public void transferCopyTo(int z) {
        this.destination.replaceSlice(z, this.slice.duplicate());
    }

    public void transferTo(int z, VoxelsResizer resizer) {
        VoxelBuffer<T> destinationSlice = this.destination.slice(z);
        VoxelBuffer<T> transferredSlice = this.transferSlice.transferSlice(resizer, this.slice, destinationSlice, this.source.extent(), this.destination.extent());
        if (transferredSlice != destinationSlice) {
            this.destination.replaceSlice(z, transferredSlice);
        }
    }

    @FunctionalInterface
    public static interface TransferSlice<T> {
        public VoxelBuffer<T> transferSlice(VoxelsResizer var1, VoxelBuffer<T> var2, VoxelBuffer<T> var3, Extent var4, Extent var5);
    }
}

