/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import org.anchoranalysis.core.functional.unchecked.BiIntPredicate;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.projection.extrema.MaybeReplaceBufferBase;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedShortImplementation
extends MaybeReplaceBufferBase<UnsignedShortBuffer> {
    private final BiIntPredicate predicate;

    public UnsignedShortImplementation(Extent extent, BiIntPredicate predicate) {
        super(extent, VoxelsFactory.getUnsignedShort());
        this.predicate = predicate;
    }

    @Override
    protected void maybeReplaceCurrentBufferPosition(UnsignedShortBuffer buffer, UnsignedShortBuffer projection) {
        short inPixel = buffer.getRaw();
        if (this.predicate.test(PrimitiveConverter.unsignedShortToInt(inPixel), projection.getUnsigned())) {
            projection.putRaw(projection.position() - 1, inPixel);
        }
    }

    @Override
    protected void assignCurrentBufferPosition(UnsignedShortBuffer buffer, UnsignedShortBuffer projection) {
        projection.putRaw(buffer.getRaw());
    }
}

