/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import org.anchoranalysis.core.functional.unchecked.BiLongPredicate;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.projection.extrema.MaybeReplaceBufferBase;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedIntImplementation
extends MaybeReplaceBufferBase<UnsignedIntBuffer> {
    private final BiLongPredicate predicate;

    public UnsignedIntImplementation(Extent extent, BiLongPredicate predicate) {
        super(extent, VoxelsFactory.getUnsignedInt());
        this.predicate = predicate;
    }

    @Override
    protected void maybeReplaceCurrentBufferPosition(UnsignedIntBuffer buffer, UnsignedIntBuffer projection) {
        int inPixel = buffer.getRaw();
        if (this.predicate.test(PrimitiveConverter.unsignedIntToLong(inPixel), projection.getUnsigned())) {
            projection.putRaw(projection.position() - 1, inPixel);
        }
    }

    @Override
    protected void assignCurrentBufferPosition(UnsignedIntBuffer buffer, UnsignedIntBuffer projection) {
        projection.putRaw(buffer.getRaw());
    }
}

