/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import org.anchoranalysis.core.functional.unchecked.BiIntPredicate;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.projection.extrema.MaybeReplaceBufferBase;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedByteImplementation
extends MaybeReplaceBufferBase<UnsignedByteBuffer> {
    private final BiIntPredicate predicate;

    public UnsignedByteImplementation(Extent extent, BiIntPredicate predicate) {
        super(extent, VoxelsFactory.getUnsignedByte());
        this.predicate = predicate;
    }

    @Override
    protected void maybeReplaceCurrentBufferPosition(UnsignedByteBuffer buffer, UnsignedByteBuffer projection) {
        byte inPixel = buffer.getRaw();
        if (this.predicate.test(PrimitiveConverter.unsignedByteToInt(inPixel), projection.getUnsigned())) {
            projection.putRaw(projection.position() - 1, inPixel);
        }
    }

    @Override
    protected void assignCurrentBufferPosition(UnsignedByteBuffer buffer, UnsignedByteBuffer projection) {
        projection.putRaw(buffer.getRaw());
    }
}

