/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import java.nio.FloatBuffer;
import org.anchoranalysis.core.functional.unchecked.BiFloatPredicate;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.projection.extrema.MaybeReplaceBufferBase;
import org.anchoranalysis.spatial.box.Extent;

class FloatImplementation
extends MaybeReplaceBufferBase<FloatBuffer> {
    private final BiFloatPredicate predicate;

    public FloatImplementation(Extent extent, BiFloatPredicate predicate) {
        super(extent, VoxelsFactory.getFloat());
        this.predicate = predicate;
    }

    @Override
    protected void maybeReplaceCurrentBufferPosition(FloatBuffer buffer, FloatBuffer projection) {
        float inPixel = buffer.get();
        if (this.predicate.test(inPixel, projection.get())) {
            projection.put(projection.position() - 1, inPixel);
        }
    }

    @Override
    protected void assignCurrentBufferPosition(FloatBuffer buffer, FloatBuffer projection) {
        projection.put(buffer.get());
    }
}

