/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.Extent;

public abstract class Projection {
    public <T> ProjectableBuffer<T> create(VoxelDataType dataType, Extent extent) throws OperationFailedException {
        if (dataType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return this.createUnsignedByte(extent);
        }
        if (dataType.equals(UnsignedShortVoxelType.INSTANCE)) {
            return this.createUnsignedShort(extent);
        }
        if (dataType.equals(UnsignedIntVoxelType.INSTANCE)) {
            return this.createUnsignedInt(extent);
        }
        if (dataType.equals(FloatVoxelType.INSTANCE)) {
            return this.createFloat(extent);
        }
        throw new OperationFailedException("No projection buffer can be created, as voxel-data-type is unsupported: " + dataType.toString());
    }

    public abstract ProjectableBuffer<UnsignedByteBuffer> createUnsignedByte(Extent var1);

    public abstract ProjectableBuffer<UnsignedShortBuffer> createUnsignedShort(Extent var1);

    public abstract ProjectableBuffer<UnsignedIntBuffer> createUnsignedInt(Extent var1);

    public abstract ProjectableBuffer<FloatBuffer> createFloat(Extent var1);
}

