/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.image.voxel.projection.CountedProjectableBuffer;
import org.anchoranalysis.spatial.box.Extent;

class MeanIntensityBuffer<T>
extends CountedProjectableBuffer<T> {
    public MeanIntensityBuffer(VoxelsFactoryTypeBound<T> flatType, Extent extent) {
        super(flatType, extent);
    }

    @Override
    public Voxels<T> completeProjection() {
        this.divideVoxelsByCount(this.voxelsSum);
        return this.flattenFrom(this.voxelsSum);
    }

    @Override
    protected void addVoxelBufferInternal(VoxelBuffer<T> voxelBuffer, int z) {
        FloatBuffer sumBuffer = (FloatBuffer)this.voxelsSum.sliceBuffer(z);
        this.voxelsSum.extent().iterateOverXYOffset(offset -> this.incrementSumBuffer(offset, voxelBuffer.getInt(offset), sumBuffer));
    }

    private void incrementSumBuffer(int index, int toAdd, FloatBuffer sumBuffer) {
        sumBuffer.put(index, sumBuffer.get(index) + (float)toAdd);
    }
}

