/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.neighborhood;

import java.util.List;
import java.util.function.Function;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.graph.GraphWithPayload;
import org.anchoranalysis.image.voxel.neighborhood.EdgeAdder;
import org.anchoranalysis.image.voxel.neighborhood.EdgeAdderParameters;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

class NeighborGraphCreator<V> {
    private final EdgeAdderParameters edgeAdderParameters;
    private boolean undirected = true;

    public NeighborGraphCreator(boolean preventObjectIntersection) {
        this.edgeAdderParameters = new EdgeAdderParameters(preventObjectIntersection);
    }

    public GraphWithPayload<V, Integer> createGraphIntersectingVoxels(List<V> vertices, Function<V, ObjectMask> vertexToObject, Extent sceneExtent, boolean do3D) throws CreateException {
        return this.createGraph(vertices, vertexToObject, (vertex1, vertex2, numberVoxels) -> numberVoxels, sceneExtent, do3D);
    }

    private <E> GraphWithPayload<V, E> createGraph(List<V> vertices, Function<V, ObjectMask> vertexToObject, EdgeFromVertices<V, E> edgeFromVertices, Extent sceneExtent, boolean do3D) throws CreateException {
        GraphWithPayload graph = new GraphWithPayload(this.undirected);
        ObjectCollection objects = ObjectCollectionFactory.mapFrom(vertices, vertexToObject::apply);
        NeighborGraphCreator.checkObjectsInScene(objects, sceneExtent);
        EdgeAdder<V> edgeAdder = new EdgeAdder<V>(vertices, vertexToObject, objects, NeighborGraphCreator.createAndAddEdge(graph, edgeFromVertices), this.edgeAdderParameters);
        for (int i = 0; i < objects.size(); ++i) {
            V vertexWith = vertices.get(i);
            graph.addVertex(vertexWith);
            edgeAdder.addEdgesFor(i, objects.get(i), vertexWith, sceneExtent, do3D);
        }
        return graph;
    }

    private static void checkObjectsInScene(ObjectCollection objects, Extent sceneExtent) throws CreateException {
        for (ObjectMask objectMask : objects) {
            if (sceneExtent.contains(objectMask.boundingBox())) continue;
            throw new CreateException(String.format("Object is not contained (fully or partially) inside scene extent: %s is not in %s", objectMask.boundingBox(), sceneExtent));
        }
    }

    private static <V, E> EdgeAdder.AddEdge<V> createAndAddEdge(GraphWithPayload<V, E> graph, EdgeFromVertices<V, E> edgeFromVertices) {
        return (vertex1, vertex2, numPixels) -> graph.addEdge(vertex1, vertex2, edgeFromVertices.createEdge(vertex1, vertex2, numPixels));
    }

    @FunctionalInterface
    public static interface EdgeFromVertices<V, E> {
        public E createEdge(V var1, V var2, int var3);
    }
}

