/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.neighborhood;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.voxel.neighborhood.EdgeAdderParameters;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalDilation;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.rtree.BoundingBoxRTree;

class EdgeAdder<V> {
    private final List<V> verticesAsList;
    private final Function<V, ObjectMask> vertexToObject;
    private final AddEdge<V> addEdge;
    private final EdgeAdderParameters parameters;
    private final BoundingBoxRTree<Integer> rTree;

    public EdgeAdder(List<V> verticesAsList, Function<V, ObjectMask> vertexToObject, ObjectCollection objects, AddEdge<V> addEdge, EdgeAdderParameters parameters) {
        this.verticesAsList = verticesAsList;
        this.vertexToObject = vertexToObject;
        this.addEdge = addEdge;
        this.parameters = parameters;
        this.rTree = EdgeAdder.createIndicesRTree(objects);
    }

    public void addEdgesFor(int ignoreIndex, ObjectMask object, V vertexWith, Extent sceneExtent, boolean do3D) throws CreateException {
        ObjectMask dilated = MorphologicalDilation.dilate(object, Optional.of(sceneExtent), do3D && sceneExtent.z() > 1, 1, this.parameters.isBigNeighborhood());
        this.addWithDilatedMask(ignoreIndex, object, vertexWith, dilated);
    }

    private void addWithDilatedMask(int ignoreIndex, ObjectMask object, V vertexWith, ObjectMask dilated) {
        Set indicesIntersects = this.rTree.intersectsWith(dilated.boundingBox());
        Iterator iterator = indicesIntersects.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            if (this.doSkipIndex(j, ignoreIndex)) continue;
            V vertexOther = this.verticesAsList.get(j);
            this.maybeAddEdge(object, dilated, this.vertexToObject.apply(vertexOther), vertexWith, this.verticesAsList.get(j));
        }
    }

    private boolean doSkipIndex(int index, int ignoreIndex) {
        return this.parameters.isTestBothDirections() ? index == ignoreIndex : index >= ignoreIndex;
    }

    private void maybeAddEdge(ObjectMask object, ObjectMask dilated, ObjectMask other, V vertexWith, V vertexOther) {
        if (this.parameters.isPreventObjectIntersection() && object.hasIntersectingVoxels(other)) {
            return;
        }
        int numberSharedVoxels = EdgeAdder.numberBorderVoxels(dilated, other);
        if (numberSharedVoxels > 0) {
            this.addEdge.addEdge(vertexWith, vertexOther, numberSharedVoxels);
        }
    }

    private static BoundingBoxRTree<Integer> createIndicesRTree(ObjectCollection objects) {
        BoundingBoxRTree tree = new BoundingBoxRTree(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            tree.add(objects.get(i).boundingBox(), (Object)i);
        }
        return tree;
    }

    private static int numberBorderVoxels(ObjectMask object1Dilated, ObjectMask object2) {
        return object1Dilated.countIntersectingVoxels(object2);
    }

    @FunctionalInterface
    public static interface AddEdge<V> {
        public void addEdge(V var1, V var2, int var3);
    }
}

