/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.neighborhood;

import lombok.Generated;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.neighborhood.Neighborhood;

final class BigNeighborhood
implements Neighborhood {
    private final boolean includeCenterPoint;

    public BigNeighborhood() {
        this.includeCenterPoint = false;
    }

    @Override
    public void processNeighborhoodPoints(boolean useZ, ProcessVoxelNeighbor<?> process) {
        if (useZ) {
            for (int z = -1; z <= 1; ++z) {
                if (!process.notifyChangeZ(z)) continue;
                this.walkXYForZ(process, z);
            }
        } else if (process.notifyChangeZ(0)) {
            this.walkXY(process);
        }
    }

    private void walkXY(ProcessVoxelNeighbor<?> process) {
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                if (!this.includeCenterPoint && x == 0 && y == 0) continue;
                process.processPoint(x, y);
            }
        }
    }

    private void walkXYForZ(ProcessVoxelNeighbor<?> process, int z) {
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                if (!this.includeCenterPoint && x == 0 && y == 0 && z == 0) continue;
                process.processPoint(x, y);
            }
        }
    }

    @Generated
    public BigNeighborhood(boolean includeCenterPoint) {
        this.includeCenterPoint = includeCenterPoint;
    }
}

