/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel.outline;

import java.util.Optional;
import java.util.function.Supplier;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.LocalSlices;
import org.anchoranalysis.image.voxel.kernel.outline.OutlineKernelBase;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class OutlineKernelNeighborMatchValue
extends OutlineKernelBase {
    private final BinaryVoxels<UnsignedByteBuffer> voxelsRequireHigh;
    private final BinaryValuesByte bvRequireHigh;
    private LocalSlices localSlicesRequireHigh;

    public OutlineKernelNeighborMatchValue(BinaryVoxels<UnsignedByteBuffer> mask) {
        this.voxelsRequireHigh = mask;
        this.bvRequireHigh = this.voxelsRequireHigh.binaryValues().asByte();
    }

    @Override
    public void notifyBuffer(LocalSlices slices, int sliceIndex) {
        super.notifyBuffer(slices, sliceIndex);
        this.localSlicesRequireHigh = new LocalSlices(sliceIndex, 3, this.voxelsRequireHigh.voxels());
    }

    @Override
    protected boolean doesNeighborQualify(boolean inside, KernelPointCursor point, Supplier<UnsignedByteBuffer> buffer, int zShift) {
        if (inside) {
            Optional<UnsignedByteBuffer> requireSlice = this.localSlicesRequireHigh.getLocal(zShift);
            return point.isBufferOff(buffer.get()) && this.checkIfRequireHighIsTrue(requireSlice.get(), point.getPoint());
        }
        return point.isOutsideOffUnignored();
    }

    private boolean checkIfRequireHighIsTrue(UnsignedByteBuffer additionalBuffer, Point3i point) {
        int indexGlobal = this.voxelsRequireHigh.extent().offsetSlice((ReadableTuple3i)point);
        return this.bvRequireHigh.isOn(additionalBuffer.getRaw(indexGlobal));
    }
}

