/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel.morphological;

import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.ConditionalKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.morphological.DilationKernel;
import org.anchoranalysis.image.voxel.object.morphological.predicate.AcceptIterationPredicate;
import org.anchoranalysis.spatial.point.Point3i;

public class DilationContext {
    private final KernelApplicationParameters kernelApplication;
    private final boolean bigNeighborhood;
    private final Optional<Predicate<Point3i>> precondition;
    private final Optional<AcceptIterationPredicate> postcondition;

    public DilationContext(OutsideKernelPolicy outsideKernelPolicy, boolean useZ, boolean bigNeighborhood, Optional<Predicate<Point3i>> precondition) {
        this(outsideKernelPolicy, useZ, bigNeighborhood, precondition, Optional.empty());
    }

    public DilationContext(OutsideKernelPolicy outsideKernelPolicy, boolean useZ, boolean bigNeighborhood, Optional<Predicate<Point3i>> precondition, Optional<AcceptIterationPredicate> postcondition) {
        this.kernelApplication = new KernelApplicationParameters(outsideKernelPolicy, useZ);
        this.bigNeighborhood = bigNeighborhood;
        this.precondition = precondition;
        this.postcondition = postcondition;
    }

    public BinaryKernel createKernel() {
        DilationKernel kernelDilation = new DilationKernel(this.bigNeighborhood);
        if (this.precondition.isPresent()) {
            return new ConditionalKernel(kernelDilation, this.precondition.get());
        }
        return kernelDilation;
    }

    @Generated
    public KernelApplicationParameters getKernelApplication() {
        return this.kernelApplication;
    }

    @Generated
    public Optional<AcceptIterationPredicate> getPostcondition() {
        return this.postcondition;
    }
}

