/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel;

import java.util.function.Predicate;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.LocalSlices;
import org.anchoranalysis.spatial.point.Point3i;

public class ConditionalKernel
extends BinaryKernel {
    private BinaryKernel kernel;
    private Predicate<Point3i> predicate;

    public ConditionalKernel(BinaryKernel kernel, Predicate<Point3i> predicate) {
        super(kernel.getSize());
        this.kernel = kernel;
        this.predicate = predicate;
    }

    @Override
    public boolean calculateAt(KernelPointCursor point) {
        if (this.predicate.test(point.getPoint())) {
            return this.kernel.calculateAt(point);
        }
        return false;
    }

    @Override
    public void notifyBuffer(LocalSlices slices, int sliceIndex) {
        this.kernel.notifyBuffer(slices, sliceIndex);
    }
}

