/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.image.voxel.iterator.neighbor.kernel.IterateKernelHelper;
import org.anchoranalysis.image.voxel.iterator.process.ProcessKernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.count.CountKernel;
import org.anchoranalysis.math.arithmetic.Counter;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ApplyKernel {
    private static final VoxelsFactoryTypeBound<UnsignedByteBuffer> FACTORY = VoxelsFactory.getUnsignedByte();

    public static BinaryVoxels<UnsignedByteBuffer> apply(final BinaryKernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, KernelApplicationParameters parameters) {
        final Voxels<UnsignedByteBuffer> out = FACTORY.createInitialized(voxels.extent());
        final BinaryValuesByte outBinaryValues = voxels.binaryValues().asByte();
        IterateKernelHelper.overAll(kernel, voxels, parameters, new ProcessKernelPointCursor(){
            private UnsignedByteBuffer outBuffer;

            @Override
            public void notifyChangeSlice(int z) {
                this.outBuffer = (UnsignedByteBuffer)out.sliceBuffer(z);
            }

            @Override
            public void process(KernelPointCursor point) {
                byte outValue = kernel.calculateAt(point) ? outBinaryValues.getOn() : outBinaryValues.getOff();
                this.outBuffer.putRaw(point.getIndex(), outValue);
            }
        });
        return BinaryVoxelsFactory.reuseByte(out, outBinaryValues.asInt());
    }

    public static int applyForCount(CountKernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, KernelApplicationParameters parameters) {
        try {
            return ApplyKernel.applyForCount(kernel, voxels, new BoundingBox(voxels.extent()), parameters);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public static int applyForCount(CountKernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box, KernelApplicationParameters parameters) throws OperationFailedException {
        Counter counter = new Counter();
        IterateKernelHelper.overBox(kernel, voxels, box, parameters, point -> counter.incrementBy(kernel.calculateAt(point)));
        return counter.getCount();
    }

    public static boolean applyUntilPositive(CountKernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box, KernelApplicationParameters parameters) throws OperationFailedException {
        return IterateKernelHelper.overBoxUntil(kernel, voxels, box, parameters, point -> kernel.calculateAt(point) > 0);
    }

    public static int applyForCount(BinaryKernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, KernelApplicationParameters parameters) {
        Counter counter = new Counter();
        IterateKernelHelper.overAll(kernel, voxels, parameters, point -> {
            if (kernel.calculateAt(point)) {
                counter.increment();
            }
        });
        return counter.getCount();
    }

    @Generated
    private ApplyKernel() {
    }
}

