/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor;

import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessChangedPointAbsoluteMasked;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

final class WithinObjectMask<T>
implements ProcessVoxelNeighbor<T> {
    private final ProcessChangedPointAbsoluteMasked<T> delegate;
    private final ObjectMask object;
    private final Extent extent;
    private final ReadableTuple3i cornerMin;
    private Point3i point;
    private Point3i relativeToCorner;
    private UnsignedByteBuffer bufferObject;
    private byte maskOffVal;
    private int maskOffsetXYAtPoint;

    public WithinObjectMask(ProcessChangedPointAbsoluteMasked<T> process, ObjectMask object) {
        this.delegate = process;
        this.object = object;
        this.maskOffVal = object.binaryValuesByte().getOff();
        this.extent = object.extent();
        this.cornerMin = object.boundingBox().cornerMin();
    }

    @Override
    public void initSource(Point3i point, int sourceValue, int sourceOffsetXY) {
        this.point = point;
        this.updateRel(point);
        this.maskOffsetXYAtPoint = this.extent.offsetSlice((ReadableTuple3i)this.relativeToCorner);
        this.delegate.initSource(sourceValue, sourceOffsetXY);
    }

    @Override
    public boolean notifyChangeZ(int zChange) {
        int z1 = this.point.z() + zChange;
        int relZ1 = this.relativeToCorner.z() + zChange;
        if (relZ1 < 0 || relZ1 >= this.extent.z()) {
            this.bufferObject = null;
            return false;
        }
        int zRel = z1 - this.cornerMin.z();
        this.bufferObject = this.object.sliceBufferLocal(zRel);
        this.delegate.notifyChangeZ(zChange, z1, this.bufferObject);
        return true;
    }

    @Override
    public void processPoint(int xChange, int yChange) {
        int x1 = this.point.x() + xChange;
        int y1 = this.point.y() + yChange;
        int relX1 = this.relativeToCorner.x() + xChange;
        int relY1 = this.relativeToCorner.y() + yChange;
        if (relX1 < 0) {
            return;
        }
        if (relX1 >= this.extent.x()) {
            return;
        }
        if (relY1 < 0) {
            return;
        }
        if (relY1 >= this.extent.y()) {
            return;
        }
        int offset = this.maskOffsetXYAtPoint + xChange + yChange * this.extent.x();
        if (this.bufferObject.getRaw(offset) != this.maskOffVal) {
            this.delegate.processPoint(xChange, yChange, x1, y1, offset);
        }
    }

    @Override
    public T collectResult() {
        return this.delegate.collectResult();
    }

    private void updateRel(Point3i point) {
        this.relativeToCorner = Point3i.immutableSubtract((ReadableTuple3i)point, (ReadableTuple3i)this.cornerMin);
    }
}

