/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor;

import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsolute;
import org.anchoranalysis.spatial.box.Extent;

public abstract class ProcessVoxelNeighborAbsoluteWithSlidingBuffer<T>
implements ProcessVoxelNeighborAbsolute<T> {
    private final SlidingBuffer<?> slidingBuffer;
    private final Extent extent;
    protected int zChange;
    protected int sourceValue;
    private VoxelBuffer<?> buffer;
    private int sourceOffsetXY;

    protected ProcessVoxelNeighborAbsoluteWithSlidingBuffer(SlidingBuffer<?> slidingBuffer) {
        this.slidingBuffer = slidingBuffer;
        this.extent = slidingBuffer.extent();
    }

    @Override
    public void initSource(int sourceValue, int sourceOffsetXY) {
        this.sourceOffsetXY = sourceOffsetXY;
        this.sourceValue = sourceValue;
    }

    @Override
    public void notifyChangeZ(int zChange, int z) {
        this.buffer = this.slidingBuffer.bufferRelative(zChange);
        this.zChange = zChange;
    }

    public Extent extent() {
        return this.extent;
    }

    protected int changedOffset(int xChange, int yChange) {
        return this.sourceOffsetXY + this.extent.offset(xChange, yChange);
    }

    protected int getInt(int index) {
        return this.buffer.getInt(index);
    }

    protected int getInt(int xChange, int yChange) {
        return this.buffer.getInt(this.changedOffset(xChange, yChange));
    }

    protected void putInt(int index, int valueToAssign) {
        this.buffer.putInt(index, valueToAssign);
    }
}

