/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.iterator.SlidingBufferProcessor;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

public class IterateVoxelsObjectMaskOptional {
    public static void withPoint(Optional<ObjectMask> objectMask, Extent extent, ProcessPoint process) {
        if (objectMask.isPresent()) {
            IterateVoxelsObjectMask.withPoint(objectMask.get(), process);
        } else {
            IterateVoxelsAll.withPoint(extent, process);
        }
    }

    public static <T> void withBuffer(Optional<ObjectMask> objectMask, Voxels<T> voxels, ProcessBufferUnary<T> process) {
        if (objectMask.isPresent()) {
            IterateVoxelsObjectMask.withBuffer(objectMask.get(), voxels, process);
        } else {
            IterateVoxelsAll.withBuffer(voxels, process);
        }
    }

    public static <S, T> void withTwoBuffers(Optional<ObjectMask> objectMask, Voxels<S> voxels1, Voxels<T> voxels2, ProcessBufferBinary<S, T> process) {
        if (objectMask.isPresent()) {
            IterateVoxelsObjectMask.withTwoBuffers(objectMask.get(), voxels1, voxels2, process);
        } else {
            IterateVoxelsAll.withTwoBuffersAndPoint(voxels1, voxels2, process);
        }
    }

    public static void withSlidingBuffer(Optional<ObjectMask> objectMask, SlidingBuffer<?> buffer, ProcessPoint process) {
        buffer.seek(objectMask.map(object -> object.boundingBox().cornerMin().z()).orElse(0));
        IterateVoxelsObjectMaskOptional.withPoint(objectMask, buffer.extent(), new SlidingBufferProcessor(buffer, process));
    }

    @Generated
    private IterateVoxelsObjectMaskOptional() {
    }
}

