/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.consumer.ScalarThreeDimensionalConsumer;

public class IterateVoxelsEqualTo {
    public static void equalToReusePoint(Voxels<UnsignedByteBuffer> voxels, byte equalToValue, Consumer<Point3i> consumer) {
        IterateVoxelsAll.withBuffer(voxels, (point, buffer, offset) -> {
            if (buffer.getRaw(offset) == equalToValue) {
                consumer.accept(point);
            }
        });
    }

    public static void equalToPrimitive(Voxels<UnsignedByteBuffer> voxels, byte equalToValue, ScalarThreeDimensionalConsumer consumer) {
        Extent extent = voxels.extent();
        extent.iterateOverZ(z -> IterateVoxelsEqualTo.equalToPrimitiveSlice(voxels, z, equalToValue, consumer));
    }

    public static void equalToPrimitiveSlice(Voxels<UnsignedByteBuffer> voxels, int sliceIndex, byte equalToValue, ScalarThreeDimensionalConsumer consumer) {
        UnsignedByteBuffer buffer = voxels.sliceBuffer(sliceIndex);
        voxels.extent().iterateOverXY((x, y, offset) -> {
            if (buffer.getRaw() == equalToValue) {
                consumer.accept(x, y, sliceIndex);
            }
        });
    }

    public static Optional<Point3i> untilFirstIntensityEqualTo(BoundedVoxels<UnsignedByteBuffer> voxels, byte equalToValue) {
        Extent extentMask = voxels.extent();
        ReadableTuple3i corner = voxels.boundingBox().cornerMin();
        for (int z = 0; z < extentMask.z(); ++z) {
            UnsignedByteBuffer bufferMask = voxels.sliceBufferLocal(z);
            for (int y = 0; y < extentMask.y(); ++y) {
                for (int x = 0; x < extentMask.x(); ++x) {
                    if (bufferMask.getRaw() != equalToValue) continue;
                    return Optional.of(new Point3i(corner.x() + x, corner.y(), corner.z() + z));
                }
            }
        }
        return Optional.empty();
    }

    @Generated
    private IterateVoxelsEqualTo() {
    }
}

