/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.factory;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataTypeFactoryMultiplexer;
import org.anchoranalysis.image.voxel.factory.FactoryUnsignedByte;
import org.anchoranalysis.image.voxel.factory.FactoryUnsignedFloat;
import org.anchoranalysis.image.voxel.factory.FactoryUnsignedInt;
import org.anchoranalysis.image.voxel.factory.FactoryUnsignedShort;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.spatial.box.Extent;

public class VoxelsFactory
extends VoxelDataTypeFactoryMultiplexer<VoxelsFactoryTypeBound<?>> {
    private static VoxelsFactory instance;
    private static final VoxelsFactoryTypeBound<UnsignedByteBuffer> FACTORY_UNSIGNED_BYTE;
    private static final VoxelsFactoryTypeBound<UnsignedShortBuffer> FACTORY_UNSIGNED_SHORT;
    private static final VoxelsFactoryTypeBound<UnsignedIntBuffer> FACTORY_UNSIGNED_INT;
    private static final VoxelsFactoryTypeBound<FloatBuffer> FACTORY_FLOAT;

    private VoxelsFactory() {
        super(FACTORY_UNSIGNED_BYTE, FACTORY_UNSIGNED_SHORT, FACTORY_UNSIGNED_INT, FACTORY_FLOAT);
    }

    public static VoxelsFactory instance() {
        if (instance == null) {
            instance = new VoxelsFactory();
        }
        return instance;
    }

    public <T> VoxelsUntyped createFrom(SliceBufferIndex<T> buffer, VoxelDataType dataType) {
        VoxelsFactoryTypeBound factory = (VoxelsFactoryTypeBound)this.get(dataType);
        Voxels<T> voxels = factory.create(buffer);
        return new VoxelsUntyped(voxels);
    }

    public VoxelsUntyped createEmpty(Extent extent, VoxelDataType dataType) {
        VoxelsFactoryTypeBound factory = (VoxelsFactoryTypeBound)this.get(dataType);
        Voxels buffer = factory.createInitialized(extent);
        return new VoxelsUntyped(buffer);
    }

    public static VoxelsFactoryTypeBound<UnsignedByteBuffer> getUnsignedByte() {
        return FACTORY_UNSIGNED_BYTE;
    }

    public static VoxelsFactoryTypeBound<UnsignedShortBuffer> getUnsignedShort() {
        return FACTORY_UNSIGNED_SHORT;
    }

    public static VoxelsFactoryTypeBound<UnsignedIntBuffer> getUnsignedInt() {
        return FACTORY_UNSIGNED_INT;
    }

    public static VoxelsFactoryTypeBound<FloatBuffer> getFloat() {
        return FACTORY_FLOAT;
    }

    static {
        FACTORY_UNSIGNED_BYTE = new FactoryUnsignedByte();
        FACTORY_UNSIGNED_SHORT = new FactoryUnsignedShort();
        FACTORY_UNSIGNED_INT = new FactoryUnsignedInt();
        FACTORY_FLOAT = new FactoryUnsignedFloat();
    }
}

