/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter.predicate;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.extracter.predicate.VoxelsPredicate;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsBoundingBox;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferUnary;
import org.anchoranalysis.image.voxel.object.DeriveObjectFromPoints;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.arithmetic.Counter;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class PredicateImplementation<T>
implements VoxelsPredicate {
    private final Voxels<T> voxels;
    private final Predicate<T> predicate;

    @Override
    public boolean anyExists() {
        return IterateVoxelsAll.anyPredicateMatch(this.voxels, this.predicate);
    }

    @Override
    public int count() {
        return this.countPredicate(IterateVoxelsAll::withVoxelBuffer);
    }

    @Override
    public int countForObject(ObjectMask object) {
        return this.countPredicate((voxelsToProcess, processor) -> IterateVoxelsObjectMask.withVoxelBuffer(object, voxelsToProcess, processor));
    }

    @Override
    public boolean higherCountExistsThan(int threshold) {
        return this.predicateMatchWithCounter(threshold + 1);
    }

    @Override
    public boolean lowerCountExistsThan(int threshold) {
        return !this.predicateMatchWithCounter(threshold);
    }

    @Override
    public ObjectMask deriveObject(BoundingBox box) {
        ObjectMask object = new ObjectMask(box);
        byte outOn = object.binaryValuesByte().getOn();
        Point3i shiftForMask = Point3i.immutableScale((ReadableTuple3i)object.boundingBox().cornerMin(), (int)-1);
        IterateVoxelsBoundingBox.withTwoMixedBuffers(box, (ReadableTuple3i)shiftForMask, this.voxels, object.voxels(), (point, buffer1, buffer2, offset1, offset2) -> {
            buffer1.position(offset1);
            if (this.predicate.test(buffer1.buffer())) {
                buffer2.putRaw(offset2, outOn);
            }
        });
        return object;
    }

    @Override
    public Optional<ObjectMask> deriveObjectTight() {
        DeriveObjectFromPoints deriver = new DeriveObjectFromPoints();
        IterateVoxelsAll.withVoxelBuffer(this.voxels, (point, buffer, offset) -> {
            buffer.position(offset);
            if (this.predicate.test(buffer.buffer())) {
                deriver.add((ReadableTuple3i)point);
            }
        });
        return deriver.deriveObject();
    }

    private boolean predicateMatchWithCounter(int threshold) {
        Counter counter = new Counter();
        return IterateVoxelsAll.anyPredicateMatch(this.voxels, buffer -> {
            if (this.predicate.test(buffer)) {
                counter.increment();
                return counter.getCount() == threshold;
            }
            return false;
        });
    }

    private int countPredicate(BiConsumer<Voxels<T>, ProcessVoxelBufferUnary<T>> consumer) {
        Counter counter = new Counter();
        consumer.accept(this.voxels, (buffer, offset) -> {
            buffer.position(offset);
            if (this.predicate.test(buffer.buffer())) {
                counter.increment();
            }
        });
        return counter.getCount();
    }

    @Generated
    public PredicateImplementation(Voxels<T> voxels, Predicate<T> predicate) {
        this.voxels = voxels;
        this.predicate = predicate;
    }
}

