/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracterAsIntBase;
import org.anchoranalysis.image.voxel.projection.MeanIntensityProjection;
import org.anchoranalysis.image.voxel.projection.extrema.MaxIntensityProjection;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedShortImplementation
extends VoxelsExtracterAsIntBase<UnsignedShortBuffer> {
    public UnsignedShortImplementation(Voxels<UnsignedShortBuffer> voxels) {
        super(voxels);
    }

    @Override
    public void copySingleVoxelTo(UnsignedShortBuffer sourceBuffer, int sourceIndex, UnsignedShortBuffer destinationBuffer, int destinationIndex) {
        destinationBuffer.putRaw(destinationIndex, sourceBuffer.getRaw(sourceIndex));
    }

    @Override
    protected int voxelAtBufferIndex(UnsignedShortBuffer buffer, int index) {
        return buffer.getUnsigned(index);
    }

    @Override
    protected boolean bufferValueGreaterThan(UnsignedShortBuffer buffer, int threshold) {
        return buffer.getUnsigned() > threshold;
    }

    @Override
    protected boolean bufferValueEqualTo(UnsignedShortBuffer buffer, int value) {
        return buffer.getUnsigned() == value;
    }

    @Override
    protected ProjectableBuffer<UnsignedShortBuffer> createMaxIntensityBuffer(Extent extent) {
        return new MaxIntensityProjection().createUnsignedShort(extent);
    }

    @Override
    protected ProjectableBuffer<UnsignedShortBuffer> createMeanIntensityBuffer(Extent extent) {
        return new MeanIntensityProjection().createUnsignedShort(extent);
    }
}

