/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracterAsIntBase;
import org.anchoranalysis.image.voxel.projection.MeanIntensityProjection;
import org.anchoranalysis.image.voxel.projection.extrema.MaxIntensityProjection;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedByteImplementation
extends VoxelsExtracterAsIntBase<UnsignedByteBuffer> {
    public UnsignedByteImplementation(Voxels<UnsignedByteBuffer> voxels) {
        super(voxels);
    }

    @Override
    public void copySingleVoxelTo(UnsignedByteBuffer sourceBuffer, int sourceIndex, UnsignedByteBuffer destinationBuffer, int destinationIndex) {
        destinationBuffer.putRaw(destinationIndex, sourceBuffer.getRaw(sourceIndex));
    }

    @Override
    protected int voxelAtBufferIndex(UnsignedByteBuffer buffer, int index) {
        return buffer.getUnsigned(index);
    }

    @Override
    protected boolean bufferValueGreaterThan(UnsignedByteBuffer buffer, int threshold) {
        return buffer.getUnsigned() > threshold;
    }

    @Override
    protected boolean bufferValueEqualTo(UnsignedByteBuffer buffer, int value) {
        return buffer.getUnsigned() == value;
    }

    @Override
    protected ProjectableBuffer<UnsignedByteBuffer> createMaxIntensityBuffer(Extent extent) {
        return new MaxIntensityProjection().createUnsignedByte(extent);
    }

    @Override
    protected ProjectableBuffer<UnsignedByteBuffer> createMeanIntensityBuffer(Extent extent) {
        return new MeanIntensityProjection().createUnsignedByte(extent);
    }
}

