/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert.imglib2;

import java.nio.FloatBuffer;
import lombok.Generated;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.convert.imglib2.ArrayFactory;
import org.anchoranalysis.image.voxel.convert.imglib2.ConvertToNativeImg;
import org.anchoranalysis.image.voxel.convert.imglib2.WrapNativeImg;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.Extent;

public class ConvertToImg {
    public static Img<? extends RealType<?>> from(VoxelsUntyped voxels) {
        VoxelDataType dataType = voxels.getVoxelDataType();
        if (dataType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return ConvertToNativeImg.fromByte(voxels.asByte());
        }
        if (dataType.equals(UnsignedShortVoxelType.INSTANCE)) {
            return ConvertToNativeImg.fromShort(voxels.asShort());
        }
        if (dataType.equals(FloatVoxelType.INSTANCE)) {
            return ConvertToNativeImg.fromFloat(voxels.asFloat());
        }
        throw new IncorrectVoxelTypeException("Only unsigned byte, short and float are supported");
    }

    public static Img<? extends RealType<?>> fromSlice(VoxelsUntyped voxels, int sliceIndex) {
        return ConvertToImg.fromBuffer(voxels.slice(sliceIndex), voxels.extent());
    }

    public static Img<UnsignedByteType> fromByte(VoxelBuffer<UnsignedByteBuffer> buffer, Extent extent) {
        return WrapNativeImg.buffer(buffer, extent, ArrayFactory::fromByte, UnsignedByteType::new);
    }

    public static Img<UnsignedShortType> fromShort(VoxelBuffer<UnsignedShortBuffer> buffer, Extent extent) {
        return WrapNativeImg.buffer(buffer, extent, ArrayFactory::fromShort, UnsignedShortType::new);
    }

    public static Img<FloatType> fromFloat(VoxelBuffer<FloatBuffer> buffer, Extent extent) {
        return WrapNativeImg.buffer(buffer, extent, ArrayFactory::fromFloat, FloatType::new);
    }

    public static Img<UnsignedByteType> fromByte(Voxels<UnsignedByteBuffer> voxels) {
        return ConvertToNativeImg.fromByte(voxels);
    }

    public static Img<UnsignedShortType> fromShort(Voxels<UnsignedShortBuffer> voxels) {
        return ConvertToNativeImg.fromShort(voxels);
    }

    public static Img<FloatType> fromFloat(Voxels<FloatBuffer> voxels) {
        return ConvertToNativeImg.fromFloat(voxels);
    }

    private static Img<? extends RealType<?>> fromBuffer(VoxelBuffer<?> voxels, Extent extent) {
        VoxelDataType dataType = voxels.dataType();
        if (dataType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return ConvertToImg.fromByte(voxels, extent);
        }
        if (dataType.equals(UnsignedShortVoxelType.INSTANCE)) {
            return ConvertToImg.fromShort(voxels, extent);
        }
        if (dataType.equals(FloatVoxelType.INSTANCE)) {
            return ConvertToImg.fromFloat(voxels, extent);
        }
        throw new IncorrectVoxelTypeException("Only unsigned byte, short and float are supported");
    }

    @Generated
    private ConvertToImg() {
    }
}

