/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert;

import java.nio.FloatBuffer;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsRemaining;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinaryWithoutOffset;

public abstract class VoxelsConverter<T> {
    public Voxels<T> convertFrom(VoxelsUntyped from, VoxelsFactoryTypeBound<T> factory) {
        Voxels<T> voxelsOut = factory.createInitialized(from.any().extent());
        try {
            this.copyFrom(from, voxelsOut);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
        return voxelsOut;
    }

    public void copyFrom(VoxelsUntyped from, Voxels<T> to) throws OperationFailedException {
        VoxelDataType fromType = from.getVoxelDataType();
        if (fromType.equals(UnsignedByteVoxelType.INSTANCE)) {
            this.copyFromUnsignedByte(from.asByte(), to);
        } else if (fromType.equals(FloatVoxelType.INSTANCE)) {
            this.copyFromFloat(from.asFloat(), to);
        } else if (fromType.equals(UnsignedShortVoxelType.INSTANCE)) {
            this.copyFromUnsignedShort(from.asShort(), to);
        } else if (fromType.equals(UnsignedIntVoxelType.INSTANCE)) {
            this.copyFromUnsignedInt(from.asInt(), to);
        }
    }

    public void copyFromUnsignedByte(Voxels<UnsignedByteBuffer> from, Voxels<T> to) throws OperationFailedException {
        this.convertAllSlices(from, to, this::convertUnsignedByte);
    }

    public void copyFromUnsignedShort(Voxels<UnsignedShortBuffer> from, Voxels<T> to) throws OperationFailedException {
        this.convertAllSlices(from, to, this::convertUnsignedShort);
    }

    public void copyFromUnsignedInt(Voxels<UnsignedIntBuffer> from, Voxels<T> to) throws OperationFailedException {
        this.convertAllSlices(from, to, this::convertUnsignedInt);
    }

    public void copyFromFloat(Voxels<FloatBuffer> from, Voxels<T> to) throws OperationFailedException {
        this.convertAllSlices(from, to, this::convertFloat);
    }

    protected abstract void convertUnsignedByte(UnsignedByteBuffer var1, T var2);

    protected abstract void convertUnsignedShort(UnsignedShortBuffer var1, T var2);

    protected abstract void convertUnsignedInt(UnsignedIntBuffer var1, T var2);

    protected abstract void convertFloat(FloatBuffer var1, T var2);

    private <S> void convertAllSlices(Voxels<S> in, Voxels<T> out, ProcessBufferBinaryWithoutOffset<S, T> process) throws OperationFailedException {
        if (!in.extent().equals((Object)out.extent())) {
            throw new OperationFailedException(String.format("The extent of the source (%s) is not equal to the destination (%s)", in, out));
        }
        in.extent().iterateOverZ(z -> IterateVoxelsRemaining.withTwoBuffersWithoutOffset(in.slice(z), out.slice(z), process));
    }
}

