/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.convert.VoxelsConverter;

public final class ToUnsignedShortScaleByType
extends VoxelsConverter<UnsignedShortBuffer> {
    private static final int DIVIDE_BY_UNSIGNED_INT = 65537;
    private static final int MULTIPLY_BY_UNSIGNED_BYTE = 257;

    @Override
    protected void convertUnsignedByte(UnsignedByteBuffer in, UnsignedShortBuffer out) {
        out.putUnsigned(in.getUnsigned() * 257);
    }

    @Override
    protected void convertUnsignedShort(UnsignedShortBuffer in, UnsignedShortBuffer out) {
        out.putRaw(in.getRaw());
    }

    @Override
    protected void convertUnsignedInt(UnsignedIntBuffer in, UnsignedShortBuffer out) {
        out.putLongClamped(in.getUnsigned() / 65537L);
    }

    @Override
    protected void convertFloat(FloatBuffer in, UnsignedShortBuffer out) {
        out.putDouble(in.get() / 65537.0f);
    }
}

