/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.convert.ToUnsignedByte;

public final class ToUnsignedByteScaleByMaxValue
extends ToUnsignedByte {
    private float scale;

    public ToUnsignedByteScaleByMaxValue(int maxValue) {
        this.setMaxValue(maxValue);
    }

    public void setMaxValue(long maxValue) {
        this.scale = 255.0f / (float)maxValue;
    }

    @Override
    protected void convertUnsignedShort(UnsignedShortBuffer in, UnsignedByteBuffer out) {
        out.putFloatClamped(this.scale * (float)in.getUnsigned());
    }

    @Override
    protected void convertUnsignedInt(UnsignedIntBuffer in, UnsignedByteBuffer out) {
        out.putFloatClamped(this.scale * (float)in.getUnsigned());
    }

    @Override
    protected void convertFloat(FloatBuffer in, UnsignedByteBuffer out) {
        out.putFloatClamped(this.scale * in.get());
    }
}

