/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.slice;

import java.util.function.Consumer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferUnary;
import org.anchoranalysis.spatial.box.Extent;

public interface SliceBufferIndex<T> {
    public VoxelBuffer<T> slice(int var1);

    default public T sliceBuffer(int z) {
        return this.slice(z).buffer();
    }

    public void replaceSlice(int var1, VoxelBuffer<T> var2);

    public Extent extent();

    default public void iterateOverSlices(Consumer<VoxelBuffer<T>> sliceConsumer) {
        int zMax = this.extent().z();
        for (int z = 0; z < zMax; ++z) {
            sliceConsumer.accept(this.slice(z));
        }
    }

    default public void iterateOverSlicesAndOffsets(ProcessVoxelBufferUnary<T> process) {
        this.iterateOverSlices(buffer -> this.extent().iterateOverXYOffset(offset -> process.process((VoxelBuffer)buffer, offset)));
    }
}

