/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.slice;

import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferFactory;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.spatial.box.Extent;

public class FromShort
implements SliceBufferIndex<UnsignedShortBuffer> {
    private final VoxelBuffer<UnsignedShortBuffer>[] buffer;
    private final Extent extent;

    public static SliceBufferIndex<UnsignedShortBuffer> createInitialized(Extent extent) {
        FromShort p = new FromShort(extent);
        p.initialize();
        return p;
    }

    public static SliceBufferIndex<UnsignedShortBuffer> createUninitialized(Extent extent) {
        return new FromShort(extent);
    }

    private FromShort(Extent extent) {
        assert (extent.z() > 0);
        this.extent = extent;
        this.buffer = VoxelBufferFactory.allocateUnsignedShortArray(extent.z());
    }

    private void initialize() {
        int volumeXY = this.extent.areaXY();
        for (int z = 0; z < this.extent.z(); ++z) {
            this.buffer[z] = VoxelBufferFactory.allocateUnsignedShort(volumeXY);
        }
    }

    @Override
    public void replaceSlice(int z, VoxelBuffer<UnsignedShortBuffer> sliceToAssign) {
        sliceToAssign.buffer().clear();
        this.buffer[z] = sliceToAssign;
    }

    @Override
    public VoxelBuffer<UnsignedShortBuffer> slice(int z) {
        VoxelBuffer<UnsignedShortBuffer> buf = this.buffer[z];
        buf.buffer().clear();
        return buf;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }
}

