/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.primitive;

import com.google.common.base.Preconditions;
import java.nio.IntBuffer;
import lombok.Generated;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBuffer;

public final class UnsignedIntBuffer
extends UnsignedBuffer {
    private final IntBuffer delegate;

    public static UnsignedIntBuffer allocate(int capacity) {
        return new UnsignedIntBuffer(IntBuffer.allocate(capacity));
    }

    public static UnsignedIntBuffer wrapRaw(int[] array) {
        return new UnsignedIntBuffer(IntBuffer.wrap(array));
    }

    public static UnsignedIntBuffer wrapRaw(IntBuffer bufferRaw) {
        return new UnsignedIntBuffer(bufferRaw);
    }

    private UnsignedIntBuffer(IntBuffer delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public int getRaw() {
        return this.delegate.get();
    }

    public int getRaw(int index) {
        return this.delegate.get(index);
    }

    public long getUnsigned() {
        return PrimitiveConverter.unsignedIntToLong(this.getRaw());
    }

    public long getUnsigned(int index) {
        return PrimitiveConverter.unsignedIntToLong(this.getRaw(index));
    }

    public void putRaw(int value) {
        this.delegate.put(value);
    }

    public void putRaw(int index, int value) {
        this.delegate.put(index, value);
    }

    public void putUnsigned(long value) {
        this.putRaw((int)value);
    }

    public void putUnsigned(int index, long value) {
        this.putRaw(index, (int)value);
    }

    @Override
    public void putFloat(float value) {
        this.putRaw((int)value);
    }

    @Override
    public void putFloat(int index, float value) {
        this.putRaw(index, (int)value);
    }

    @Override
    public void putDouble(double value) {
        this.putRaw((int)value);
    }

    @Override
    public void putDouble(int index, double value) {
        this.putRaw(index, (int)value);
    }

    @Override
    public void putLong(long value) {
        this.putUnsigned(value);
    }

    public final int[] array() {
        Preconditions.checkArgument((boolean)this.delegate.hasArray());
        return this.delegate.array();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnsignedIntBuffer)) {
            return false;
        }
        UnsignedIntBuffer other = (UnsignedIntBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnsignedIntBuffer;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public IntBuffer getDelegate() {
        return this.delegate;
    }
}

