/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer;

import java.nio.ByteBuffer;
import org.anchoranalysis.image.voxel.buffer.DuplicateBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferUnsigned;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

final class VoxelBufferUnsignedInt
extends VoxelBufferUnsigned<UnsignedIntBuffer> {
    public VoxelBufferUnsignedInt(UnsignedIntBuffer buffer) {
        super(buffer);
    }

    @Override
    public VoxelBuffer<UnsignedIntBuffer> duplicate() {
        return new VoxelBufferUnsignedInt(DuplicateBuffer.copy((UnsignedIntBuffer)this.buffer()));
    }

    @Override
    public VoxelDataType dataType() {
        return UnsignedIntVoxelType.INSTANCE;
    }

    @Override
    public int getInt(int index) {
        return ((UnsignedIntBuffer)this.buffer()).getRaw(index);
    }

    @Override
    public void putInt(int index, int value) {
        ((UnsignedIntBuffer)this.buffer()).putRaw(index, value);
    }

    @Override
    public void putByte(int index, byte value) {
        ((UnsignedIntBuffer)this.buffer()).putRaw(index, PrimitiveConverter.unsignedByteToInt(value));
    }

    @Override
    public void copyVoxelFrom(int destinationIndex, VoxelBuffer<UnsignedIntBuffer> src, int sourceIndex) {
        ((UnsignedIntBuffer)this.buffer()).putRaw(destinationIndex, src.buffer().getRaw(sourceIndex));
    }

    @Override
    public ByteBuffer underlyingBytes() {
        ByteBuffer bufferSigned = ByteBuffer.allocate(this.capacity() * 4);
        bufferSigned.asIntBuffer().put(((UnsignedIntBuffer)this.buffer()).getDelegate());
        return bufferSigned;
    }
}

