/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary.values;

import lombok.Generated;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;

public final class BinaryValuesInt {
    private static final BinaryValuesInt DEFAULT = new BinaryValuesInt(0, 255);
    private final int off;
    private final int on;

    public BinaryValuesByte asByte() {
        if (this.off > 255) {
            throw new IncorrectVoxelTypeException("offInt must be <= 255");
        }
        if (this.on > 255) {
            throw new IncorrectVoxelTypeException("onInt must be <= 255");
        }
        return new BinaryValuesByte(this.off, this.on);
    }

    public static BinaryValuesInt getDefault() {
        return DEFAULT;
    }

    public BinaryValuesInt createInverted() {
        return new BinaryValuesInt(this.on, this.off);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryValuesInt)) {
            return false;
        }
        BinaryValuesInt other = (BinaryValuesInt)o;
        if (this.getOff() != other.getOff()) {
            return false;
        }
        return this.getOn() == other.getOn();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOff();
        result = result * 59 + this.getOn();
        return result;
    }

    @Generated
    public BinaryValuesInt(int off, int on) {
        this.off = off;
        this.on = on;
    }

    @Generated
    public int getOff() {
        return this.off;
    }

    @Generated
    public int getOn() {
        return this.on;
    }
}

